/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import noppes.npcs.NBTTags;
import noppes.npcs.client.Client;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.EntityNPCInterface;

public class GuiNpcPather
extends GuiNPCInterface
implements IGuiData {
    private List<int[]> path;
    private GuiCustomScroll scroll;

    public GuiNpcPather(EntityNPCInterface npc) {
        super(npc);
        this.drawDefaultBackground = false;
        this.xSize = 176;
        this.title = "Npc Pather";
        this.setBackground("smallbg.png");
        this.path = npc.ais.getMovingPath();
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (this.scroll.getSelect() < 0) {
            return;
        }
        switch (button.getID()) {
            case 0: {
                ArrayList<int[]> list = new ArrayList<int[]>(this.path);
                int selected = this.scroll.getSelect();
                if (list.size() <= selected + 1) {
                    return;
                }
                int[] a = (int[])list.get(selected);
                int[] b = (int[])list.get(selected + 1);
                list.set(selected, b);
                list.set(selected + 1, a);
                this.path = list;
                this.func_73866_w_();
                this.scroll.setSelect(selected + 1);
                break;
            }
            case 1: {
                if (this.scroll.getSelect() - 1 < 0) {
                    return;
                }
                ArrayList<int[]> list = new ArrayList<int[]>(this.path);
                int selected = this.scroll.getSelect();
                int[] a = (int[])list.get(selected);
                int[] b = (int[])list.get(selected - 1);
                list.set(selected, b);
                list.set(selected - 1, a);
                this.path = list;
                this.func_73866_w_();
                this.scroll.setSelect(selected - 1);
                break;
            }
            case 2: {
                ArrayList<int[]> list = new ArrayList<int[]>(this.path);
                if (list.size() <= 1) {
                    return;
                }
                list.remove(this.scroll.getSelect());
                this.scroll.setSelect(this.scroll.getSelect() - 1);
                this.path = list;
                this.func_73866_w_();
                break;
            }
        }
        this.npc.ais.setMovingPath(this.path);
    }

    protected void drawGuiContainerBackgroundLayer(float ignoredF, int ignoredI, int ignoredJ) {
    }

    @Override
    public void func_73866_w_() {
        int sel;
        if (this.scroll != null) {
            sel = this.scroll.getSelect();
        } else {
            sel = 0;
            Vec3d vec3d = this.player.func_174824_e(1.0f);
            Vec3d vec3d2 = this.player.func_70676_i(1.0f);
            Vec3d vec3d3 = vec3d.func_72441_c(vec3d2.field_72450_a * 6.0, vec3d2.field_72448_b * 6.0, vec3d2.field_72449_c * 6.0);
            RayTraceResult result = this.player.field_70170_p.func_147447_a(vec3d, vec3d3, false, false, true);
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                int x = result.func_178782_a().func_177958_n();
                int y = result.func_178782_a().func_177956_o();
                int z = result.func_178782_a().func_177952_p();
                int i = 0;
                for (int[] arr : this.path) {
                    if (arr[0] == x && y == arr[1] && z == arr[2]) {
                        sel = i;
                        break;
                    }
                    ++i;
                }
            }
        }
        super.func_73866_w_();
        this.scroll = new GuiCustomScroll(this, 0);
        this.scroll.setSize(160, 164);
        ArrayList<String> list = new ArrayList<String>();
        for (int[] arr : this.path) {
            list.add("x:" + arr[0] + " y:" + arr[1] + " z:" + arr[2]);
        }
        this.scroll.setListNotSorted(list);
        this.scroll.guiLeft = this.guiLeft + 7;
        this.scroll.guiTop = this.guiTop + 12;
        this.scroll.setSelect(sel);
        this.addScroll(this.scroll);
        this.addButton(new GuiNpcButton(0, this.guiLeft + 6, this.guiTop + 178, 52, 20, "gui.down"));
        this.addButton(new GuiNpcButton(1, this.guiLeft + 62, this.guiTop + 178, 52, 20, "gui.up"));
        this.addButton(new GuiNpcButton(2, this.guiLeft + 118, this.guiTop + 178, 52, 20, "selectWorld.deleteButton"));
    }

    @Override
    public void initPacket() {
        Client.sendData(EnumPacketServer.MovingPathGet, new Object[0]);
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 || this.isInventoryKey(i)) {
            this.close();
        }
    }

    @Override
    public void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        this.scroll.func_73864_a(i, j, k);
    }

    @Override
    public void save() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("MovingPathNew", (NBTBase)NBTTags.nbtIntegerArraySet(this.path));
        Client.sendData(EnumPacketServer.MovingPathSave, compound);
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        this.path = NBTTags.getIntegerArraySet(compound.func_150295_c("MovingPathNew", 10));
        this.npc.ais.setMovingPath(this.path);
        this.func_73866_w_();
    }
}

